/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.jobs.model;

import com.badlogic.gdx.math.GridPoint2;
import java.util.Objects;
import technology.rocketjump.undermount.entities.SequentialIdGenerator;
import technology.rocketjump.undermount.entities.model.physical.item.ItemType;
import technology.rocketjump.undermount.jobs.model.JobPriority;
import technology.rocketjump.undermount.jobs.model.JobState;
import technology.rocketjump.undermount.jobs.model.JobType;
import technology.rocketjump.undermount.jobs.model.Profession;
import technology.rocketjump.undermount.rooms.ItemAllocation;

public class Job {
    private final long jobId;
    private final JobType type;
    private JobState jobState;
    private JobPriority jobPriority = JobPriority.NORMAL;
    private Long targetEntityId;
    private ItemAllocation itemAllocation;
    private Long assignedToEntityId;
    private float totalWorkToDo;
    private float workDoneSoFar;
    private GridPoint2 jobLocation;
    private GridPoint2 secondaryLocation;
    private Profession requiredProfession;
    private ItemType itemTypeRequiredForWork;

    public Job(JobType type) {
        this.jobId = SequentialIdGenerator.nextId();
        this.type = type;
        this.jobState = JobState.POTENTIALLY_ACCESSIBLE;
        this.requiredProfession = type.getRequiredProfession();
        this.itemTypeRequiredForWork = type.getItemTypeRequiredForWork();
    }

    public long getJobId() {
        return this.jobId;
    }

    public JobType getType() {
        return this.type;
    }

    public JobState getJobState() {
        return this.jobState;
    }

    public void setJobState(JobState jobState) {
        this.jobState = jobState;
    }

    public long getTargetEntityId() {
        return this.targetEntityId;
    }

    public void setTargetEntityId(long targetEntityId) {
        this.targetEntityId = targetEntityId;
    }

    public Long getAssignedToEntityId() {
        return this.assignedToEntityId;
    }

    public void setAssignedToEntityId(Long assignedToEntityId) {
        this.assignedToEntityId = assignedToEntityId;
    }

    public float getTotalWorkToDo() {
        return this.totalWorkToDo;
    }

    public void setTotalWorkToDo(float totalWorkToDo) {
        this.totalWorkToDo = totalWorkToDo;
    }

    public float getWorkDoneSoFar() {
        return this.workDoneSoFar;
    }

    public void setWorkDoneSoFar(float workDoneSoFar) {
        this.workDoneSoFar = workDoneSoFar;
    }

    public GridPoint2 getJobLocation() {
        return this.jobLocation;
    }

    public void setJobLocation(GridPoint2 jobLocation) {
        this.jobLocation = jobLocation;
    }

    public void setTargetEntityId(Long targetEntityId) {
        this.targetEntityId = targetEntityId;
    }

    public Profession getRequiredProfession() {
        return this.requiredProfession;
    }

    public void setRequiredProfession(Profession requiredProfession) {
        this.requiredProfession = requiredProfession;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Job job = (Job)o;
        return this.jobId == job.jobId;
    }

    public int hashCode() {
        return Objects.hash(this.jobId);
    }

    public void applyWorkDone(float workDone) {
        this.workDoneSoFar += workDone;
    }

    public JobPriority getJobPriority() {
        return this.jobPriority;
    }

    public void setJobPriority(JobPriority jobPriority) {
        this.jobPriority = jobPriority;
    }

    public ItemAllocation getItemAllocation() {
        return this.itemAllocation;
    }

    public void setItemAllocation(ItemAllocation itemAllocation) {
        this.itemAllocation = itemAllocation;
    }

    public ItemType getItemTypeRequiredForWork() {
        return this.itemTypeRequiredForWork;
    }

    public void setItemTypeRequiredForWork(ItemType itemTypeRequiredForWork) {
        this.itemTypeRequiredForWork = itemTypeRequiredForWork;
    }

    public GridPoint2 getSecondaryLocation() {
        return this.secondaryLocation;
    }

    public void setSecondaryLocation(GridPoint2 secondaryLocation) {
        this.secondaryLocation = secondaryLocation;
    }

    public String toString() {
        return "Job{jobId=" + this.jobId + ", type=" + (Object)((Object)this.type) + ", jobState=" + (Object)((Object)this.jobState) + '}';
    }
}

